{
	"woodenTower":{
		"type":"defenseTower",
		"age":"woodenAge",
		"no":0,
		"picture":{"file":"woodenTower.png",
				   "file100":"woodenTower100.atf"},
		"name":{"EN":"wooden tower",
				"FR":"tour en bois"},
		"description":{"EN":"The wooden tower is a light defense tower which shoot assegais to enemies.",
					   "FR":"La tour en bois est une tourelle légère qui tire des sagaies sur vos ennemis."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"wood":250},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"building",
			"xpSkill":{"building":1},
			"xpSecondaryCharacteristic":{"strength":1},
			"prebuild":{"id":"woodenTowerYard", "time":0.5}
		},
		"repair":{
			"health":4,
			"time":0.5,
			"costRessource":{"wood":1},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":1},
			"xpSecondaryCharacteristic":{"endurance":1}
		},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":64,
		"height":128,
		"visualHeight":160,
		"health":1000,
		"attack":200, "attackTime":3, "range":500, "missile":"assegaiMissile", "attackDY":-104, "sound":"soundThrow",
		"damage":["missile", "piercing"],
		"defense":100,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0}
	},
	"woodenTowerYard":{
		"type":"prebuild",
		"picture":{"file":"woodenTowerYard.png",
				   "file100":"woodenTowerYard100.atf"},
		"name":{"EN":"wooden tower",
				"FR":"tour en bois"},
		"description":{"EN":"The wooden tower is a light defense tower which shoot assegais to enemies.",
					   "FR":"La tour en bois est une tourelle légère qui tire des sagaies sur vos ennemis."},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":64,
		"height":128,
		"visualHeight":160,
		"defense":100,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0},
		"steps":0
	},
	"totem":{
		"type":"resurrectTower",
		"age":"woodenAge",
		"no":1,
		"picture":{"file":"totem.png",
				   "file100":"totem100.atf"},
		"name":{"EN":"totem",
				"FR":"totem"},
		"description":{"EN":"The totem can resurrect one dead person.",
					   "FR":"Le totem permet de ressusciter une personne morte."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"wood":40},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"sculpting",
			"xpSkill":{"sculpting":1},
			"xpSecondaryCharacteristic":{"address":1},
			"prebuild":{"id":"totemYard", "time":0.5}
		},
		"repair":{
			"health":3,
			"time":0.5,
			"costRessource":{"wood":1},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"sculpting",
			"xpSkill":{"sculpting":1},
			"xpSecondaryCharacteristic":{"address":1}
		},
		"death":{
			"effect":{"name":"destruction"}
		},
		"width":64,
		"height":56,
		"visualHeight":64,
		"health":120,
		"resurrect":1, "resurrectTime":2, "healthResurrection":0.1, "effectResurrection":"resurrectionEffect",
		"defense":100,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0}
	},
	"totemYard":{
		"type":"prebuild",
		"picture":{"file":"totemYard.png",
				   "file100":"totemYard100.atf"},
		"name":{"EN":"totem",
				"FR":"totem"},
		"description":{"EN":"The totem can resurrect one dead person.",
					   "FR":"Le totem permet de ressusciter une personne morte."},
		"death":{
			"effect":{"name":"destruction"}
		},
		"width":64,
		"height":56,
		"visualHeight":64,
		"defense":100,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0},
		"steps":0
	},
	"palisade":{
		"type":"wall",
		"age":"stoneAge",
		"no":2,
		"picture":{"file":"palisade.png",
				   "file100":"palisade100.atf"},
		"name":{"EN":"palisade",
				"FR":"palissade"},
		"description":{"EN":"The palisade block the advance of enemies.",
					   "FR":"La palissade bloque les enemies."},
		"build":{
			"chooseLocation":true,
			"locationStep":32,
			"buildable":"all",
			"costRessource":{"wood":20},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"fortification",
			"xpSkill":{"fortification":1},
			"xpSecondaryCharacteristic":{"strength":1},
			"prebuild":{"id":"palisadeYard", "time":0.5}
		},
		"repair":{
			"health":25,
			"time":0.5,
			"costRessource":{"wood":1},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":1},
			"xpSecondaryCharacteristic":{"endurance":1}
		},
		"death":{
			"effect":{"name":"destruction", "scale":0.5}
		},
		"width":30,
		"visualWidth":32,
		"height":30,
		"visualHeight":64,
		"health":500,
		"defense":100,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0}
	},
	"palisadeYard":{
		"type":"prebuild",
		"picture":{"file":"palisadeYard.png",
				   "file100":"palisadeYard100.atf"},
		"name":{"EN":"palisade",
				"FR":"palissade"},
		"description":{"EN":"The palisade block the advance of enemies.",
					   "FR":"La palissade bloque les enemies."},
		"death":{
			"effect":{"name":"destruction", "scale":0.5}
		},
		"width":30,
		"visualWidth":32,
		"height":30,
		"visualHeight":64,
		"defense":100,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0},
		"steps":0
	},
	"palisadeNS":{
		"type":"wall",
		"age":"stoneAge",
		"picture":{"file":"palisadeNS.png",
				   "file100":"palisadeNS100.atf"},
		"name":{"EN":"palisade",
				"FR":"palissade"},
		"description":{"EN":"The palisade block the advance of enemies.",
					   "FR":"La palissade bloque les enemies."},
		"build":{
			"costRessource":{"wood":20},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"fortification",
			"xpSkill":{"fortification":1},
			"xpSecondaryCharacteristic":{"strength":1},
			"prebuild":{"id":"palisadeYard", "time":0.5}
		},
		"repair":{
			"health":25,
			"time":0.5,
			"costRessource":{"wood":1},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":1},
			"xpSecondaryCharacteristic":{"endurance":1}
		},
		"death":{
			"effect":{"name":"destruction", "scale":0.5}
		},
		"width":30,
		"visualWidth":32,
		"height":30,
		"visualHeight":64,
		"health":500,
		"defense":100,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0}
	},
	"palisadeWE":{
		"type":"wall",
		"age":"stoneAge",
		"picture":{"file":"palisadeWE.png",
				   "file100":"palisadeWE100.atf"},
		"name":{"EN":"palisade",
				"FR":"palissade"},
		"description":{"EN":"The palisade block the advance of enemies.",
					   "FR":"La palissade bloque les enemies."},
		"build":{
			"costRessource":{"wood":20},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"fortification",
			"xpSkill":{"fortification":1},
			"xpSecondaryCharacteristic":{"strength":1},
			"prebuild":{"id":"palisadeYard", "time":0.5}
		},
		"repair":{
			"health":25,
			"time":0.5,
			"costRessource":{"wood":1},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":1},
			"xpSecondaryCharacteristic":{"endurance":1}
		},
		"death":{
			"effect":{"name":"destruction", "scale":0.5}
		},
		"width":30,
		"visualWidth":36,
		"height":30,
		"visualHeight":64,
		"health":500,
		"defense":100,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0}
	},
	"advWoodenTower":{
		"type":"defenseTower",
		"age":"stoneAge",
		"no":3,
		"picture":{"file":"advWoodenTower.png",
				   "file100":"advWoodenTower100.atf"},
		"name":{"EN":"adv wooden tower",
				"FR":"tour en bois évoluée"},
		"description":{"EN":"The advanced wooden tower is defense tower which shoot arrows to enemies.",
					   "FR":"La tour en bois évoluée est une tourelle de défense qui tire des flèches sur vos ennemis."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"plank":250},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"building",
			"xpSkill":{"building":1},
			"xpSecondaryCharacteristic":{"strength":1},
			"prebuild":{"id":"advWoodenTowerYard", "time":0.5}
		},
		"repair":{
			"health":6,
			"time":0.5,
			"costRessource":{"plank":1},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":1},
			"xpSecondaryCharacteristic":{"endurance":1}
		},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":64,
		"height":128,
		"visualHeight":160,
		"health":1500,
		"attack":400, "attackTime":3, "range":500, "missile":"arrow", "attackDY":-104, "sound":"soundBow",
		"damage":["missile", "piercing"],
		"defense":150,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0}
	},
	"advWoodenTowerYard":{
		"type":"prebuild",
		"picture":{"file":"advWoodenTowerYard.png",
				   "file100":"advWoodenTowerYard100.atf"},
		"name":{"EN":"adv wooden tower",
				"FR":"tour en bois évoluée"},
		"description":{"EN":"The advanced wooden tower is defense tower which shoot arrows to enemies.",
					   "FR":"La tour en bois évoluée est une tourelle de défense qui tire des flèches sur vos ennemis."},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":64,
		"height":128,
		"visualHeight":160,
		"defense":100,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0},
		"steps":0
	},
	"soulsStatue":{
		"type":"resurrectTower",
		"age":"stoneAge",
		"no":4,
		"picture":{"file":"soulsStatue.png",
				   "file100":"soulsStatue100.atf"},
		"name":{"EN":"souls statue",
				"FR":"statue des âmes"},
		"description":{"EN":"The souls statue can resurrect dead people.",
					   "FR":"La statue des âmes permet de ressusciter des personnages morts."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"freeStone":50},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"sculpting",
			"xpSkill":{"sculpting":2},
			"xpSecondaryCharacteristic":{"address":2},
			"prebuild":{"id":"soulsStatueYard", "time":1}
		},
		"repair":{
			"health":6,
			"time":1,
			"costRessource":{"freeStone":1},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"sculpting",
			"xpSkill":{"sculpting":2},
			"xpSecondaryCharacteristic":{"address":2}
		},
		"death":{
			"effect":{"name":"destruction"}
		},
		"width":64,
		"height":56,
		"visualHeight":64,
		"health":300,
		"resurrect":5, "resurrectTime":3, "healthResurrection":0.2, "effectResurrection":"resurrectionEffect",
		"defense":150,
		"resistance":{"light":0.5, "death":0.5, "explosion":2, "poison":0}
	},
	"soulsStatueYard":{
		"type":"prebuild",
		"picture":{"file":"soulsStatueYard.png",
				   "file100":"soulsStatueYard100.atf"},
		"name":{"EN":"souls statue",
				"FR":"statue des âmes"},
		"description":{"EN":"The souls statue can resurrect dead people.",
					   "FR":"La statue des âmes permet de ressusciter des personnages morts."},
		"death":{
			"effect":{"name":"destruction"}
		},
		"width":64,
		"height":56,
		"visualHeight":64,
		"defense":150,
		"steps":0,
		"resistance":{"light":0.5, "death":0.5, "explosion":2, "poison":0}
	},
	"barrack":{
		"type":"barrack",
		"age":"stoneAge",
		"no":5,
		"picture":{"file":"barrack.png",
				   "file100":"barrack100.atf"},
		"name":{"EN":"barrack",
				"FR":"caserne"},
		"description":{"EN":"The barrack allow to recruit soldiers.",
					   "FR":"La caserne vous permet de recruter des soldats."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"freeStone":100, "plank":100},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"building",
			"xpSkill":{"building":2},
			"xpSecondaryCharacteristic":{"strength":2},
			"prebuild":{"id":"barrackYard", "time":1}
		},
		"title":{"EN":"Recruit soldiers", "FR":"Recruter des soldats"},
		"produce":[{
				"time":4,
				"createCharacter":{"militiaman":1},
				"bonusTimeSkill":"conscription",
				"costRessource":{"silverCoin":8},
				"costPrimaryCharacteristic":{"stamina":8},
				"xpSecondaryCharacteristic":{"charisma":8},
				"xpSkill":{"conscription":8},
				"repeat":true
			},{
				"time":8,
				"createCharacter":{"archer":1},
				"bonusTimeSkill":"conscription",
				"costRessource":{"silverCoin":16},
				"costPrimaryCharacteristic":{"stamina":16},
				"xpSecondaryCharacteristic":{"charisma":16},
				"xpSkill":{"conscription":16},
				"repeat":true
			},{
				"time":5,
				"createCharacter":{"infantryman":1},
				"bonusTimeSkill":"conscription",
				"costRessource":{"silverCoin":10},
				"costPrimaryCharacteristic":{"stamina":10},
				"xpSecondaryCharacteristic":{"charisma":10},
				"xpSkill":{"conscription":10},
				"repeat":true
			},{
				"time":18,
				"createCharacter":{"pyromage":1},
				"bonusTimeSkill":"conscription",
				"costRessource":{"silverCoin":36},
				"costPrimaryCharacteristic":{"stamina":36},
				"xpSecondaryCharacteristic":{"charisma":36},
				"xpSkill":{"conscription":36},
				"repeat":true
			},{
				"time":10,
				"createCharacter":{"cuirassier":1},
				"bonusTimeSkill":"conscription",
				"costRessource":{"silverCoin":20},
				"costPrimaryCharacteristic":{"stamina":20},
				"xpSecondaryCharacteristic":{"charisma":20},
				"xpSkill":{"conscription":20},
				"repeat":true
			}],
		"repair":{
			"health":20,
			"time":1.5,
			"costRessource":{"freeStone":1, "plank":1},
			"costPrimaryCharacteristic":{"stamina":3},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":3},
			"xpSecondaryCharacteristic":{"endurance":3}
		},
		"death":{
			"effect":{"name":"destruction", "scale":2}
		},
		"width":128,
		"height":160,
		"visualHeight":192,
		"health":2000,
		"defense":150,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0}
	},
	"barrackYard":{
		"type":"prebuild",
		"picture":{"file":"barrackYard.png",
				   "file100":"barrackYard100.atf"},
		"name":{"EN":"barrack",
				"FR":"caserne"},
		"description":{"EN":"The barrack allow to recruit soldiers.",
					   "FR":"La caserne vous permet de recruter des soldats."},
		"death":{
			"effect":{"name":"destruction", "scale":2}
		},
		"width":128,
		"height":160,
		"visualHeight":192,
		"defense":150,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0},
		"steps":3
	},
	"stoneGolem":{
		"type":"buildingMonster",
		"age":"stoneAge",
		"no":6,
		"picture":{"file":"stoneGolem.png",
				   "file100":"stoneGolem100.atf"},
		"name":{"EN":"stone golem",
				"FR":"golem de pierre"},
		"description":{"EN":"The stone golem is a mobile golem which punch enemies.",
					   "FR":"Le golem de pierre est un golem mobile qui cogne vos ennemis."},
		"pluralName":{"EN":"stone golems",
					  "FR":"golems de pierre"},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"stone":200},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":2},
			"xpSecondaryCharacteristic":{"intelligence":2},
			"prebuild":{"id":"stoneGolemYard", "time":1}
		},
		"repair":{
			"health":10,
			"time":1,
			"costRessource":{"stone":1},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":2},
			"xpSecondaryCharacteristic":{"intelligence":2}
		},
		"death":{
			"effect":{"name":"destruction"}
		},
		"width":64,
		"height":56,
		"visualHeight":70,
		"health":2000,
		"attack":400, "attackTime":6, "attackEffect":"default",
		"damage":["closeCombat", "crushing"],
		"defense":200,
		"resistance":{"death":0.5, "explosion":2, "golemKiller":4, "poison":0},
		"speed":4
	},
	"stoneGolemYard":{
		"type":"prebuild",
		"picture":{"file":"stoneGolemYard.png",
				   "file100":"stoneGolemYard100.atf"},
		"name":{"EN":"stone golem",
				"FR":"golem de pierre"},
		"description":{"EN":"The stone golem is a mobile golem which punch enemies.",
					   "FR":"Le golem de pierre est un golem mobile qui cogne vos ennemis."},
		"death":{
			"effect":{"name":"destruction"}
		},
		"width":64,
		"height":56,
		"visualHeight":70,
		"defense":200,
		"resistance":{"fire":1.5, "death":0.5, "explosion":2, "poison":0},
		"steps":5
	},
	"stoneGolemCarcass":{
		"type":"landRessource",
		"age":"stoneAge",
		"picture":{"file":"stoneGolemCarcass.png",
				   "file100":"stoneGolemCarcass100.atf"},
		"name":{"EN":"stone golem carcass",
				"FR":"caracasse de golem de pierre"},
		"description":{"EN":"Stone golem carcass provide stone.",
					   "FR":"La caracasse de golem fournit de la pierre."},
		"age":"stoneAge",
		"quantity":50,
		"produce":[{
				"time":1,
				"gainRessource":{"stone":1},
				"sound":"soundRock",
				"anim":"shake",
				"bonusSkill":"stonecutting",
				"costPrimaryCharacteristic":{"stamina":2},
				"xpSecondaryCharacteristic":{"strength":2},
				"xpSkill":{"stonecutting":2},
				"repeat":true,
				"quantity":-1
			}],
		"width":64,
		"height":32
	},
	"stoneWall":{
		"type":"wall",
		"age":"ironAge",
		"no":7,
		"picture":{"file":"stoneWall.png",
				   "file100":"stoneWall100.atf"},
		"name":{"EN":"stone wall",
				"FR":"mur de pierre"},
		"description":{"EN":"The stone wall block the advance of enemies.",
					   "FR":"Le mur de pierre bloque les enemies."},
		"build":{
			"chooseLocation":true,
			"locationStep":32,
			"buildable":"all",
			"costRessource":{"freeStone":20},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"fortification",
			"xpSkill":{"fortification":2},
			"xpSecondaryCharacteristic":{"strength":2},
			"prebuild":{"id":"stoneWallYard", "time":1}
		},
		"repair":{
			"health":50,
			"time":1,
			"costRessource":{"freeStone":1},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":2},
			"xpSecondaryCharacteristic":{"endurance":2}
		},
		"death":{
			"effect":{"name":"destruction", "scale":0.5}
		},
		"width":30,
		"visualWidth":32,
		"height":30,
		"visualHeight":64,
		"health":1000,
		"defense":300,
		"resistance":{"death":0.5, "explosion":2, "poison":0}
	},
	"stoneWallYard":{
		"type":"prebuild",
		"picture":{"file":"stoneWallYard.png",
				   "file100":"stoneWallYard100.atf"},
		"name":{"EN":"stone wall",
				"FR":"mur de pierre"},
		"description":{"EN":"The stone wall block the advance of enemies.",
					   "FR":"Le mur de pierre bloque les enemies."},
		"death":{
			"effect":{"name":"destruction", "scale":0.5}
		},
		"width":30,
		"visualWidth":32,
		"height":30,
		"visualHeight":64,
		"defense":300,
		"resistance":{"death":0.5, "explosion":2, "poison":0},
		"steps":0
	},
	"stoneWallNS":{
		"type":"wall",
		"age":"ironAge",
		"picture":{"file":"stoneWallNS.png",
				   "file100":"stoneWallNS100.atf"},
		"name":{"EN":"stone wall",
				"FR":"mur de pierre"},
		"description":{"EN":"The stone wall block the advance of enemies.",
					   "FR":"Le mur de pierre bloque les enemies."},
		"build":{
			"costRessource":{"freeStone":20},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"fortification",
			"xpSkill":{"fortification":2},
			"xpSecondaryCharacteristic":{"strength":2},
			"prebuild":{"id":"stoneWallYard", "time":1}
		},
		"repair":{
			"health":50,
			"time":1,
			"costRessource":{"freeStone":1},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":2},
			"xpSecondaryCharacteristic":{"endurance":2}
		},
		"death":{
			"effect":{"name":"destruction", "scale":0.5}
		},
		"width":30,
		"visualWidth":32,
		"height":30,
		"visualHeight":64,
		"health":1000,
		"defense":300,
		"resistance":{"death":0.5, "explosion":2, "poison":0}
	},
	"stoneWallWE":{
		"type":"wall",
		"age":"ironAge",
		"picture":{"file":"stoneWallWE.png",
				   "file100":"stoneWallWE100.atf"},
		"name":{"EN":"stone wall",
				"FR":"mur de pierre"},
		"description":{"EN":"The stone wall block the advance of enemies.",
					   "FR":"Le mur de pierre bloque les enemies."},
		"build":{
			"costRessource":{"freeStone":20},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"fortification",
			"xpSkill":{"fortification":2},
			"xpSecondaryCharacteristic":{"strength":2},
			"prebuild":{"id":"stoneWallYard", "time":1}
		},
		"repair":{
			"health":50,
			"time":1,
			"costRessource":{"freeStone":1},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":2},
			"xpSecondaryCharacteristic":{"endurance":2}
		},
		"death":{
			"effect":{"name":"destruction", "scale":0.5}
		},
		"width":30,
		"visualWidth":36,
		"height":30,
		"visualHeight":64,
		"health":500,
		"defense":100,
		"resistance":{"death":0.5, "explosion":2, "poison":0}
	},
	"stoneTower":{
		"type":"defenseTower",
		"age":"ironAge",
		"no":8,
		"picture":{"file":"stoneTower.png",
				   "file100":"stoneTower100.atf"},
		"name":{"EN":"stone tower",
				"FR":"tour en pierre"},
		"description":{"EN":"The stone tower is a tough defense tower which shoot bolts to enemies.",
					   "FR":"La tour en pierre est une tourelle résistante qui tire des carreaux sur vos ennemis."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"freeStone":250},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"building",
			"xpSkill":{"building":2},
			"xpSecondaryCharacteristic":{"strength":2},
			"prebuild":{"id":"stoneTowerYard", "time":1}
		},
		"repair":{
			"health":12,
			"time":1,
			"costRessource":{"freeStone":1},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":2},
			"xpSecondaryCharacteristic":{"endurance":2}
		},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":64,
		"height":128,
		"visualHeight":160,
		"health":3000,
		"attack":400, "attackTime":3, "range":500, "missile":"bolt", "attackDY":-84, "sound":"soundCrossbow",
		"damage":["missile", "piercing"],
		"defense":300,
		"resistance":{"death":0.5, "explosion":2, "poison":0}
	},
	"stoneTowerYard":{
		"type":"prebuild",
		"picture":{"file":"stoneTowerYard.png",
				   "file100":"stoneTowerYard100.atf"},
		"name":{"EN":"stone tower",
				"FR":"tour en pierre"},
		"description":{"EN":"The stone tower is a tough defense tower which shoot bolts to enemies.",
					   "FR":"La tour en pierre est une tourelle résistante qui tire des carreaux sur vos ennemis."},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":64,
		"height":128,
		"visualHeight":160,
		"defense":300,
		"steps":5,
		"resistance":{"death":0.5, "explosion":2, "poison":0}
	},
	"chapel":{
		"type":"resurrectTower",
		"age":"ironAge",
		"no":9,
		"picture":{"file":"chapel.png",
				   "file100":"chapel100.atf"},
		"name":{"EN":"chapel",
				"FR":"chapelle"},
		"description":{"EN":"The chapel can resurrect dead people.",
					   "FR":"La chapelle permet de ressusciter des personnages morts."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"plank":300},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"building",
			"xpSkill":{"building":1},
			"xpSecondaryCharacteristic":{"strength":1},
			"prebuild":{"id":"chapelYard", "time":0.5}
		},
		"repair":{
			"health":4,
			"time":0.5,
			"costRessource":{"plank":1},
			"costPrimaryCharacteristic":{"stamina":1},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":1},
			"xpSecondaryCharacteristic":{"endurance":1}
		},
		"death":{
			"effect":{"name":"destruction", "scale":2}
		},
		"width":128,
		"height":160,
		"visualHeight":192,
		"health":1200,
		"resurrect":15, "resurrectTime":6, "healthResurrection":0.3, "effectResurrection":"resurrectionEffect",
		"defense":125,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0}
	},
	"chapelYard":{
		"type":"prebuild",
		"picture":{"file":"chapelYard.png",
				   "file100":"chapelYard100.atf"},
		"name":{"EN":"chapel",
				"FR":"chapelle"},
		"description":{"EN":"The chapel can resurrect dead people.",
					   "FR":"La chapelle permet de ressusciter des personnages morts."},
		"death":{
			"effect":{"name":"destruction", "scale":2}
		},
		"width":128,
		"height":160,
		"visualHeight":192,
		"defense":125,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0},
		"steps":3
	},
	"ironGolem":{
		"type":"buildingMonster",
		"age":"ironAge",
		"no":10,
		"picture":{"file":"ironGolem.png",
				   "file100":"ironGolem100.atf"},
		"name":{"EN":"iron golem",
				"FR":"golem de fer"},
		"description":{"EN":"The iron golem is a mighty mobile golem which punch enemies.",
					   "FR":"Le golem de siège est un golem puissant et mobile qui cogne vos ennemis."},
		"pluralName":{"EN":"iron golems",
					  "FR":"golems de fer"},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"castIron":200},
			"costPrimaryCharacteristic":{"stamina":3},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":3},
			"xpSecondaryCharacteristic":{"intelligence":3},
			"prebuild":{"id":"ironGolemYard", "time":1.5}
		},
		"repair":{
			"health":10,
			"time":1.5,
			"costRessource":{"castIron":1},
			"costPrimaryCharacteristic":{"stamina":3},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":3},
			"xpSecondaryCharacteristic":{"intelligence":3}
		},
		"death":{
			"effect":{"name":"destruction"}
		},
		"width":80,
		"height":56,
		"visualHeight":80,
		"health":2000,
		"attack":400, "attackTime":5, "attackEffect":"default",
		"damage":["closeCombat", "crushing"],
		"defense":500,
		"resistance":{"death":0.5, "electricity":1.5, "explosion":2, "golemKiller":4, "poison":0},
		"speed":3
	},
	"ironGolemYard":{
		"type":"prebuild",
		"picture":{"file":"ironGolemYard.png",
				   "file100":"ironGolemYard100.atf"},
		"name":{"EN":"iron golem",
				"FR":"golem de fer"},
		"description":{"EN":"The iron golem is a mighty mobile golem which punch enemies.",
					   "FR":"Le golem de siège est un golem puissant et mobile qui cogne vos ennemis."},
		"death":{
			"effect":{"name":"destruction"}
		},
		"width":80,
		"height":56,
		"visualHeight":80,
		"defense":500,
		"resistance":{"fire":1.5, "death":0.5, "electricity":1.5, "explosion":2, "poison":0},
		"steps":3
	},
	"flameTower":{
		"type":"defenseTower",
		"age":"etherAge",
		"no":11,
		"picture":{"file":"flameTower.png",
				   "file100":"flameTower100.atf"},
		"name":{"EN":"flame tower",
				"FR":"tour de flammes"},
		"description":{"EN":"The flame tower is a powerful defense tower which fireballs to enemies.",
					   "FR":"La tour de flammes est une puissante tourelle qui tire des boules de feu sur vos ennemis."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"crystals":250},
			"costPrimaryCharacteristic":{"stamina":4},
			"sound":"soundBuilding",
			"bonusSkill":"building",
			"xpSkill":{"building":4},
			"xpSecondaryCharacteristic":{"strength":4},
			"prebuild":{"id":"flameTowerYard", "time":2}
		},
		"repair":{
			"health":8,
			"time":2,
			"costRessource":{"crystals":1},
			"costPrimaryCharacteristic":{"stamina":4},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":4},
			"xpSecondaryCharacteristic":{"endurance":4}
		},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":80,
		"height":136,
		"visualHeight":160,
		"health":2000,
		"attack":800, "attackTime":4.5, "range":500, "missile":"fireball", "attackDY":-114,
		"damage":["magic", "fire"],
		"defense":200,
		"resistance":{"magic":0.5, "explosion":2, "poison":0}
	},
	"flameTowerYard":{
		"type":"prebuild",
		"picture":{"file":"flameTowerYard.png",
				   "file100":"flameTowerYard100.atf"},
		"name":{"EN":"flame tower",
				"FR":"tour de flammes"},
		"description":{"EN":"The flame tower is a powerful defense tower which fireballs to enemies.",
					   "FR":"La tour de flammes est une puissante tourelle qui tire des boules de feu sur vos ennemis."},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":80,
		"height":136,
		"visualHeight":160,
		"defense":200,
		"steps":3,
		"resistance":{"magic":0.5, "explosion":2, "poison":0}
	},
	"crystalGolem":{
		"type":"buildingMonster",
		"age":"etherAge",
		"no":12,
		"picture":{"file":"crystalGolem.png",
				   "file100":"crystalGolem100.atf"},
		"name":{"EN":"crystal golem",
				"FR":"golem de cristal"},
		"description":{"EN":"The crystal golem is a flying golem which throw ice bolt shards.",
					   "FR":"Le golem de cristal est un golem volant qui projette des éclats de glace."},
		"pluralName":{"EN":"crystal golems",
					  "FR":"golems de cristal"},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"crystals":200},
			"costPrimaryCharacteristic":{"stamina":4},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":4},
			"xpSecondaryCharacteristic":{"intelligence":4},
			"prebuild":{"id":"crystalGolemYard", "time":2}
		},
		"repair":{
			"health":10,
			"time":2,
			"costRessource":{"crystals":1},
			"costPrimaryCharacteristic":{"stamina":4},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":4},
			"xpSecondaryCharacteristic":{"intelligence":4}
		},
		"death":{
			"effect":{"name":"destruction"}
		},
		"width":64,
		"height":64,
		"visualHeight":96,
		"health":2000,
		"attack":100, "attackTime":3, "attackEffect":"missileEffect",
		"attacks":[{"attack":100, "attackTime":9, "attackDelay":1, "range":400, "missile":"iceBolt", "attackDX":-24, "attackDY":-37, "damage":["magic", "ice"], "special":{"selfGuided":0.05, "penality":{"id":"slowdown", "time":5}}},
				   {"attack":100, "attackTime":9, "attackDelay":1.2, "range":400, "missile":"iceBolt", "attackDX":24, "attackDY":-37, "damage":["magic", "ice"], "special":{"selfGuided":0.05, "penality":{"id":"slowdown", "time":5}}},
				   {"attack":100, "attackTime":9, "attackDelay":1.4, "range":400, "missile":"iceBolt", "attackDX":-24, "attackDY":-75, "damage":["magic", "ice"], "special":{"selfGuided":0.05, "penality":{"id":"slowdown", "time":5}}},
				   {"attack":100, "attackTime":9, "attackDelay":1.6, "range":400, "missile":"iceBolt", "attackDX":24, "attackDY":-75, "damage":["magic", "ice"], "special":{"selfGuided":0.05, "penality":{"id":"slowdown", "time":5}}}],
		"damage":["closeCombat", "piercing"],
		"defense":400,
		"resistance":{"magic":0.5, "explosion":2, "golemKiller":4, "poison":0},
		"speed":5,
		"flying":true
	},
	"crystalGolemYard":{
		"type":"prebuild",
		"picture":{"file":"crystalGolemYard.png",
				   "file100":"crystalGolemYard100.atf"},
		"name":{"EN":"crystal golem",
				"FR":"golem de cristal"},
		"description":{"EN":"The crystal golem is a flying golem which throw ice bolt shards.",
					   "FR":"Le golem de cristal est un golem volant qui projette des éclats de glace."},
		"death":{
			"effect":{"name":"destruction"}
		},
		"width":64,
		"height":64,
		"visualHeight":96,
		"defense":300,
		"resistance":{"fire":1.5, "magic":0.5, "explosion":2, "poison":0},
		"steps":4
	},
	"cannonTower":{
		"type":"defenseTower",
		"age":"goldenAge",
		"no":13,
		"picture":{"file":"cannonTower.png",
				   "file100":"cannonTower100.atf"},
		"name":{"EN":"bombarde tower",
				"FR":"tour à bombarde"},
		"description":{"EN":"The bombarde tower is a tough defense tower which shoot cannon balls to enemies.",
					   "FR":"La tour à bombarde est une tourelle résistante qui tire des boulets de canon sur vos ennemis."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"freeStone":240, "sulfur":60},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"building",
			"xpSkill":{"building":2},
			"xpSecondaryCharacteristic":{"strength":2},
			"prebuild":{"id":"cannonTowerYard", "time":1}
		},
		"repair":{
			"health":10,
			"time":1,
			"costRessource":{"freeStone":1},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":2},
			"xpSecondaryCharacteristic":{"endurance":2}
		},
		"death":{
			"effect":{"name":"destruction", "scale":1.5}
		},
		"width":96,
		"height":176,
		"visualHeight":224,
		"health":2400,
		"attack":2000,
		"attackTime":20, "range":600, "missile":"cannonBall", "attackDY":-150, "sound":"soundCannon",
		"special":{"pierce":true, "area":{"attack":1000, "range":32, "effect":"miniExplosion"}},
		"damage":["missile", "explosion"],
		"defense":250,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0}
	},
	"cannonTowerYard":{
		"type":"prebuild",
		"picture":{"file":"cannonTowerYard.png",
				   "file100":"cannonTowerYard100.atf"},
		"name":{"EN":"bombarde tower",
				"FR":"tour à bombarde"},
		"description":{"EN":"The bombarde tower is a tough defense tower which shoot cannon balls to enemies.",
					   "FR":"La tour à bombarde est une tourelle résistante qui tire des boulets de canon sur vos ennemis."},
		"death":{
			"effect":{"name":"destruction", "scale":1.5}
		},
		"width":96,
		"height":176,
		"visualHeight":224,
		"defense":250,
		"resistance":{"fire":2, "death":0.5, "explosion":2, "poison":0},
		"steps":5
	},
	"goldenGolem":{
		"type":"buildingMonster",
		"age":"goldenAge",
		"no":14,
		"picture":{"file":"goldenGolem.png",
				   "file100":"goldenGolem100.atf"},
		"name":{"EN":"golden golem",
				"FR":"golem d'or"},
		"description":{"EN":"The golden golem is a ultimate mobile golem which punch enemies.",
					   "FR":"Le golem d'or est un golem suprême. Il est mobile et cogne vos ennemis."},
		"pluralName":{"EN":"golden golems",
					  "FR":"golems d'or"},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"goldBar":200},
			"costPrimaryCharacteristic":{"stamina":5},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":5},
			"xpSecondaryCharacteristic":{"intelligence":5},
			"prebuild":{"id":"goldenGolemYard", "time":2.5}
		},
		"repair":{
			"health":15,
			"time":2.5,
			"costRessource":{"goldBar":1},
			"costPrimaryCharacteristic":{"stamina":5},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":5},
			"xpSecondaryCharacteristic":{"intelligence":5}
		},
		"death":{
			"effect":{"name":"destruction", "scale":1.1}
		},
		"width":80,
		"height":72,
		"visualHeight":96,
		"health":3000,
		"attack":600, "attackTime":5, "attackEffect":"default",
		"damage":["closeCombat", "crushing"],
		"defense":600,
		"resistance":{"electricity":2, "death":0.5, "explosion":2, "golemKiller":4, "poison":0},
		"speed":5
	},
	"goldenGolemYard":{
		"type":"prebuild",
		"picture":{"file":"goldenGolemYard.png",
				   "file100":"goldenGolemYard100.atf"},
		"name":{"EN":"golden golem",
				"FR":"golem d'or"},
		"description":{"EN":"The golden golem is a ultimate mobile golem which punch enemies.",
					   "FR":"Le golem d'or est un golem suprême. Il est mobile et cogne vos ennemis."},
		"death":{
			"effect":{"name":"destruction", "scale":1.1}
		},
		"width":80,
		"height":72,
		"visualHeight":96,
		"defense":600,
		"resistance":{"fire":1.5, "electricity":2, "death":0.5, "explosion":2, "poison":0},
		"steps":5
	},
	"siegeGolem":{
		"type":"buildingMonster",
		"age":"goldenAge",
		"no":15,
		"picture":{"file":"siegeGolem.png",
				   "file100":"siegeGolem100.atf"},
		"name":{"EN":"siege golem",
				"FR":"golem de siège"},
		"description":{"EN":"The siege golem is a ultimate mobile golem which punch enemies.",
					   "FR":"Le golem de siege est un golem suprême. Il est mobile et cogne vos ennemis."},
		"pluralName":{"EN":"siege golems",
					  "FR":"golems de siège"},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"castIron":400},
			"costPrimaryCharacteristic":{"stamina":3},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":3},
			"xpSecondaryCharacteristic":{"intelligence":3},
			"prebuild":{"id":"siegeGolemYard", "time":1.5}
		},
		"repair":{
			"health":10,
			"time":1.5,
			"costRessource":{"castIron":1},
			"costPrimaryCharacteristic":{"stamina":3},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":3},
			"xpSecondaryCharacteristic":{"intelligence":3}
		},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":90,
		"height":96,
		"visualHeight":120,
		"health":4000,
		"attack":800, "attackTime":6, "attackEffect":"default",
		"damage":["closeCombat", "crushing"],
		"defense":500,
		"resistance":{"electricity":2, "death":0.5, "explosion":2, "golemKiller":4, "poison":0},
		"speed":4
	},
	"siegeGolemYard":{
		"type":"prebuild",
		"picture":{"file":"siegeGolemYard.png",
				   "file100":"siegeGolemYard100.atf"},
		"name":{"EN":"siege golem",
				"FR":"golem de siège"},
		"description":{"EN":"The siege golem is a ultimate mobile golem which punch enemies.",
					   "FR":"Le golem de siège est un golem suprême. Il est mobile et cogne vos ennemis."},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":90,
		"height":96,
		"visualHeight":120,
		"defense":500,
		"resistance":{"fire":1.5, "electricity":2, "death":0.5, "explosion":2, "poison":0},
		"steps":7
	}
}